package ibase.webitm.ejb.sys;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

public class AcknowledgementReader {

    public static Map<String, Object[]> parseXMLFiles(String directoryPath) 
    {
        Map<String, Object[]> resultMap = new HashMap<>();
        try {
            File directory = new File(directoryPath);

            if (directory.isDirectory()) {
                File[] files = directory.listFiles((dir, name) -> name.toLowerCase().endsWith(".xml"));

                if (files != null) {
                    for (File file : files) {
                        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                        Document doc = dBuilder.parse(file);
                        doc.getDocumentElement().normalize();

                        NodeList topLevelNodes = doc.getDocumentElement().getChildNodes();
                        processNodes(topLevelNodes, resultMap);
                    }
                }
            } else {
                System.out.println("Specified path is not a directory.");
            }

        } 
        
        catch (Exception e)
        {
            e.printStackTrace(); 
        }

        return resultMap;
    }

    private static void processNodes(NodeList nodes, Map<String, Object[]> resultMap) {
        for (int i = 0; i < nodes.getLength(); i++) {
            Node node = nodes.item(i);

            if (node.getNodeType() == Node.ELEMENT_NODE) {
                Element element = (Element) node;

                String orgnlEndToEndId = getElementValue(element, "OrgnlEndToEndId");
                String txSts = getElementValue(element, "TxSts");
                String rsn = getElementValue(element, "Rsn");

                List<String> addtlInfList = new ArrayList<>();
                NodeList addtlInfNodes = element.getElementsByTagName("AddtlInf");

                for (int j = 0; j < addtlInfNodes.getLength(); j++) {
                    addtlInfList.add(addtlInfNodes.item(j).getTextContent());
                }

                Object[] values = {txSts, new Object[]{rsn, addtlInfList.toArray(new String[0])}};
                resultMap.put(orgnlEndToEndId, values);

                // Recursively process child nodes
                processNodes(node.getChildNodes(), resultMap);
            }
        }
    }

    private static String getElementValue(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        return nodeList.getLength() > 0 ? nodeList.item(0).getTextContent() : "";
    }

    public static void main(String[] args) {
        String directoryPath = "/home/amol.sonawane/Documents/Acknowledgement";
        Map<String, Object[]> result = parseXMLFiles(directoryPath);

        System.out.println("Tag Values are :");
        for (Map.Entry<String, Object[]> entry : result.entrySet()) {
            System.out.println("Key: " + entry.getKey());

            Object[] values = entry.getValue();
            System.out.println("TxSts: " + (String) values[0]);

            Object[] innerArray = (Object[]) values[1];
            System.out.println("Rsn: " + (String) innerArray[0]);

            String[] addtlInfArray = (String[]) innerArray[1];
            System.out.print("AddtlInf: ");
            for (String addtlInf : addtlInfArray) {
                System.out.print(addtlInf + " ");
            }
            System.out.println("\n");
        }
    }

}
